attribute vec4 a_posUV;
attribute vec4 a_color;
attribute vec2 a_rotSize;

uniform float u_frameSize_x;
uniform float u_frameSize_y;
uniform float u_targetWidth;

varying float rotation;
varying vec2 uvPosition;
varying float v_alpha;
varying vec3 v_color;

void main()
{
    rotation = a_rotSize.x;
    uvPosition =  a_posUV.zw;
    v_alpha = a_color.a;
    v_color = a_color.xyz;
    
    gl_Position = CC_MVPMatrix * vec4(a_posUV.x, a_posUV.y, 0.0, 1.0);
    vec4 scaledOrigin = (CC_MVPMatrix * vec4(0.0, 0.0, 0.0,1.0));
    vec4 scaledPointSize = (CC_MVPMatrix * vec4(a_rotSize[1], a_rotSize[1], 0.0,1.0));
    gl_PointSize =  abs(scaledOrigin.x - scaledPointSize.x) * 0.5 * u_targetWidth;
}
